;**********************************************
; Test Read Input PORT Form PCF8574AP Out To RS232
; Hardware  : CP-PIC V3.0/V4.0 (18F458)
; OSC   10 MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 01/8/2002
;**********************************************

     LIST P=18f458
     include <p18f458.inc>

#define   BIT_SDA     PORTC,4          ; SDA bit
#define   BIT_SCL     PORTC,3	       ; SCL bit

dt1       EQU       0x20
dt2       EQU       0x21
dt3       EQU       0x22
WR_BUF    EQU       0x23
count     EQU       0x24
count10   EQU	    0x25
DAT       EQU       0x29
RD_BUF    EQU       0x30
B1        EQU       0x31
BB        EQU       0x32
SDA       EQU       4
SCL       EQU       3

;*********************************************
          ORG       0x0000
          
          bcf       TRISC,SDA	   ; PORTC.4 as output
          bcf       TRISC,SCL      ; PORTC.3 as input
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG          
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       TXSTA,TXEN     ; Transmit enable
	  bsf	    TXSTA,BRGH     ; hi speed
          clrf      RCSTA
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive
	  
NEW       movlw     0x0C           ; Clear display
          call      SEND
          movlw     "D"
          call      SEND
          movlw     "A"
          call      SEND
          movlw     "T"
          call      SEND
          movlw     "A"
          call      SEND
          movlw     " "
          call      SEND
          movlw     "I"
          call      SEND        
	  movlw     "N"
          call      SEND
          movlw     " "
          call      SEND
          
                 
          movlw     0xA             ; new line
          call      SEND
          movlw     0xD
          call      SEND
	  movlw     "="
          call      SEND
 	  movlw     " "
	  call      SEND

;*********** READ DATA FORM PCF8574AP *************
	  
          call	    START	   ; start condition
          movlw     0x71           ; control byte
          call	    WR_I2C	   ; write control address
	  movlw     0xff	   ; 
	  call      WR_I2C	   ; write data to PCF 8574AP
	  
	  call	    START	   ; start condition
          movlw     0x71           ; control byte
          call	    WR_I2C	   ; write control address
	  call	    RD_I2C	   ; read data form PCF 8574AP
	  movf      RD_BUF,w	   ; save data to w
	  
	  call      ADJT           ; display data	   
	  call	    STOP	   ; Stop condition
	  CALL	    SDel           ; delay
	  goto	    NEW



;**********************************************************
; Convert data to Ascii and display data
; Input  : W
; Output : rs 232
;**********************************************************
ADJT      movwf     BB               ; B1 = HHHH LLLL
          swapf     BB,W             ; W  = LLLL HHHH
	  call      CHECK            ; high byte 
          movf      BB,W
          call      CHECK	     ; low byte
          return

CHECK     andlw     0X0F	     ; Mask upper four bit
	  movwf     B1
	  sublw     0X0A
	  bz        CC               ; = 0XA JUMP TO CC 
	  bc        CONV             ; < 0XA JUMP TO CONV
CC	  movf      B1,W             ; A - F
	  addlw     0X37
	  call      SEND             ; SEND FIRST DIGIT
	  return
CONV      movf      B1,W             ; 0 - 9
          addlw     0X30
	  call      SEND	     ; SEND LAST DIGIT
          return
	 
	  	  



;********************************************************
; Send data to RS-232 2400 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      movwf     TXREG            ; Send recent data to TX 
wait1     lfsr      0,TXSTA
          btfss     INDF0,1          ; check TRMT bit in TXSTA register
	  goto      wait1            ; TXREG full  or TRMT = 0
          return


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C	 movwf	    WR_BUF	     ; get data to buffer
	 movlw	    .8               ; counter = 8
	 movwf	    count
	 bcf	    TRISC,SCL        ; SCL  low
	 bcf	    PORTC,SCL    
	 call	    delay
WR_LOOP  rlcf	    WR_BUF,f	     ; rotate data to carry flag
	 BC	    DATA_1	     ; Goto DATA_1 if carry = 1
DATA_0   bcf	    TRISC,SDA        ; carry = 0
	 bcf	    BIT_SDA          ; SDA Lo
	 call	    pulse	     ; clock
	 goto	    CHK
DATA_1   bsf	    TRISC,SDA        ; SDA Hi
	 call	    pulse
CHK	 decfsz	    count,f	     ; check counter loop
	 goto	    WR_LOOP
	 bsf	    TRISC,SDA        ; SDA Hi
	 call	    RD_ACK           ; read acknowledge
	 return

;*********** READ DATA FORM I2C BUS **************

RD_I2C	 movlw	    .8               ; counter = 8
	 movwf	    count
	 bcf	    TRISC,SCL        ; SCL Lo
	 bcf	    BIT_SCL
	 bsf	    TRISC,SDA	     ; SDA Hi
RD_LOOP  bsf	    TRISC,SCL        ; SCL Clock Hi
	 btfsc	    BIT_SDA          ; test bit SDA skip if SDA = 0 
	 goto	    RD_1             ; BIT_SDA = 1
RD_0	 bcf	    STATUS,C	     ; carry flag = 0    
	 goto 	    ROTATE      
RD_1     bsf	    STATUS,C	     ; carry flag = 1    
ROTATE   rlcf	    RD_BUF,f         ; rotate carry flag to buffer
	 bcf	    TRISC,SCL        ; SCL Clock Lo
	 bcf	    BIT_SCL	
	 decfsz	    count,f          ; check counter
	 goto	    RD_LOOP
	 return

RD_ACK	 bsf	    TRISC,SDA        ; SDA Hi
         bcf	    TRISC,SCL   
	 bcf	    BIT_SCL          ; SCL Lo
	 bsf	    TRISC,SCL
	 btfsc	    BIT_SDA          ; test acknowledge form SDA
	 goto	    STOP             ; NACK		
	 btfss	    BIT_SCL     
	 goto	    $-1
	 bcf	    TRISC,SCL        ; SCL Lo
	 call	    delay
	 return

S_ACK    bcf	    TRISC,SCL      
	 bcf	    BIT_SCL          ; SCL Lo
 	 bcf	    TRISC,SDA
	 bcf	    BIT_SDA          ; SDA Lo
	 bsf	    TRISC,SCL        ; SCL Hi
         bcf	    TRISC,SCL       
	 bcf	    BIT_SCL          ; SCL Lo
	 bsf	    TRISC,SDA        ; SDA Hi
	 return	 

N_ACK    bcf	    TRISC,SCL      
	 bcf	    BIT_SCL          ; SCL Lo
	 bsf	    TRISC,SDA        ; SDA Hi
	 bsf	    TRISC,SCL       
	 bcf	    BIT_SCL	     ; SCL Lo
	 return 

ACK_P    bcf	   TRISC,SCL        
	 bcf	   BIT_SCL	     ; SCL Lo
	 call	   START             ; start condition
	 movlw	   0xA0		     ; address control
	 call	   WR_I2C            ; write address control
	 bsf	   TRISC,SDA         ; SDA Hi
	 bcf	   TRISC,SCL         
    	 bcf       BIT_SCL	     ; SCL Lo
	 bsf	   TRISC,SCL         ; SCL Hi
	 btfsc	   BIT_SCL           ; test bit SCL skip "0"
	 goto	   ACK_P	     ; acknowledge pulling
	 bcf	   TRISC,SCL 
	 bcf	   BIT_SCL	     ; SCL Lo
	 return	 

START     bsf       TRISC,SDA        ; SDA = hi
          bsf       TRISC,SCL        ; SCL = hi
          btfss     BIT_SCL	     ; test bit SCL skip "1"
	  goto	    $-1		     ; wait until SCL = "1"
	  btfss	    BIT_SDA	     ; test bit SDA skip "1"
	  goto 	    $-1		     ; wait until SDA = "1"
          bcf       TRISC,SDA        
	  bcf	    BIT_SDA          ; SDA lo
          bcf       TRISC,SCL        
	  bcf	    BIT_SCL          ; SCL lo
          return

STOP	 bcf	    TRISC,SCL	     
	 bcf	    BIT_SCL	     ; SCL Lo
	 bcf	    TRISC,SDA
	 bcf	    BIT_SDA	     ; SDA Lo
	 bsf	    TRISC,SCL        ; SCL Hi
	 bsf	    TRISC,SDA        ; SDA Hi
	 call 	    delay
	 return	 

pulse     bcf	    TRISC,SCL	     
	  bcf	    BIT_SCL	     ; SCL Lo 
	  call	    delay
	  bsf       TRISC,SCL	     ; SCL Hi
	  call	    delay
	  bcf	    TRISC,SCL        
	  bcf	    BIT_SCL          ; SCL Lo
	  return          
;******************************
; Short delay
;******************************
SDel      movlw	    5
	  movwf	    dt1
sd3	  clrf      dt2
sd2       clrf      dt3
sd1       decfsz    dt3
          goto      sd1
          decfsz    dt2
          goto      sd2
	  decfsz    dt1
	  goto      sd3
          return
     
delay     movlw	    .15
	  movwf	    dt3
	  decfsz    dt3,f
	  goto	    $-1
	  return
          
          end

